/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.xfw.service.managedsystem.fru;

import com.ibm.hwmca.fw.HException;
import com.ibm.hwmca.fw.persist.PersistentData;
import com.ibm.hwmca.fw.service.managedsystem.ActivateException;
import com.ibm.hwmca.fw.service.managedsystem.AlreadyLockedException;
import com.ibm.hwmca.fw.service.managedsystem.DeactivateException;
import com.ibm.hwmca.fw.service.managedsystem.IdentifyException;
import com.ibm.hwmca.fw.service.managedsystem.LockingException;
import com.ibm.hwmca.fw.service.managedsystem.ManagedSystem;
import com.ibm.hwmca.fw.service.managedsystem.ServiceableElement;
import com.ibm.hwmca.fw.service.managedsystem.ServiceableElementException;
import com.ibm.hwmca.fw.service.managedsystem.ServiceableElementMaintenance;
import com.ibm.hwmca.fw.service.managedsystem.ServiceableElementMaintenanceException;
import com.ibm.hwmca.fw.service.managedsystem.ServiceableElementMaintenanceFactory;
import com.ibm.hwmca.fw.service.managedsystem.fru.Fru;
import com.ibm.hwmca.fw.service.managedsystem.fru.config.FruConfig;
import com.ibm.hwmca.fw.service.panel.CommonDataBean;
import com.ibm.hwmca.fw.service.panel.GenericGui;
import com.ibm.hwmca.fw.service.panel.TextAndSwappableGraphicDataBean;
import com.ibm.hwmca.fw.util.Trace;
import java.io.File;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public abstract class DefaultFru
extends Fru {
    private String fruLocationCode = "";
    private String powerDomainLocationCode = null;
    protected ServiceableElementMaintenance hardwareInterface = null;
    protected static final String TRACE_MASKT = "XRVFRUNT";
    protected static final String TRACE_MASKF = "XRVFRUNF";
    protected static final String TRACE_MASKD = "XRVFRUND";
    protected int panelStackLimit = 200;

    public abstract CommonDataBean getNextSetServicePositionBean(CommonDataBean var1);

    public abstract CommonDataBean getNextResetServicePositionBean(CommonDataBean var1);

    public abstract CommonDataBean getNextRemoveBean(CommonDataBean var1);

    public abstract CommonDataBean getNextInstallBean(CommonDataBean var1);

    public DefaultFru(PersistentData persistentData) {
        super(persistentData);
        Trace.trace(TRACE_MASKT, "<> DefaultFru.ctor( PersistentData )");
    }

    public DefaultFru(Map properties) {
        super(properties);
        Trace.trace(TRACE_MASKT, "<> DefaultFru.ctor(  Map )");
    }

    public DefaultFru() {
        Trace.trace(TRACE_MASKT, "<> DefaultFru.ctor()");
    }

    public String getPowerDomain(Map userData) throws ServiceableElementException {
        return this.getPowerDomainFromLocationCode();
    }

    protected String getPowerDomainFromLocationCode() {
        if (this.powerDomainLocationCode == null) {
            boolean isPowerBoundary;
            this.fruLocationCode = (String)this.getProperties().get("LOCATION");
            Trace.trace(TRACE_MASKT, "-> DefaultFru.getPowerDomainFromLocationCode for fru location: " + this.fruLocationCode);
            boolean bl = isPowerBoundary = (Boolean)this.getProperties().get("POWER_BOUNDARY_IS_FRU") == null ? false : (Boolean)this.getProperties().get("POWER_BOUNDARY_IS_FRU");
            if (isPowerBoundary) {
                this.getProperties().put("POWER_BOUNDARY_IS_UNIT", Boolean.FALSE);
                this.powerDomainLocationCode = this.fruLocationCode;
            } else {
                this.getProperties().put("POWER_BOUNDARY_IS_UNIT", Boolean.TRUE);
                int dash = this.fruLocationCode.indexOf(45);
                this.powerDomainLocationCode = dash == -1 ? this.fruLocationCode : this.fruLocationCode.substring(0, dash);
            }
        }
        Trace.trace(TRACE_MASKT, "<- DefaultFru.getPowerDomainFromLocationCode power domain for fru location[" + this.fruLocationCode + "]=[" + this.powerDomainLocationCode + "]");
        return this.powerDomainLocationCode;
    }

    public void displayServiceEffect(Map userData) throws ServiceableElementException {
        Trace.trace(TRACE_MASKT, "-> DefaultFru.displayServiceEffect");
        try {
            this.getHardwareInterface(userData).getServiceEffect(this.getPowerDomain(userData));
        }
        catch (Exception e) {
            Trace.trace(TRACE_MASKT, "<-! DefaultFru.displayServiceEffect exception caught: " + e);
            Trace.trace(TRACE_MASKT, e);
            throw new ServiceableElementException(e);
        }
        Trace.trace(TRACE_MASKT, "<- DefaultFru.displayServiceEffect");
    }

    public void systemLevelDeactivate(Map userData) throws DeactivateException {
        Trace.trace(TRACE_MASKT, "- DefaultFru.systemLevelDeactivate");
        try {
            this.getHardwareInterface(userData).systemLevelDeactivate(this.getPowerDomain(userData));
        }
        catch (Exception e) {
            Trace.trace(TRACE_MASKT, "<-! DefaultFru.systemLevelDeactivate exception caught: " + e);
            Trace.trace(TRACE_MASKT, e);
            throw new DeactivateException(e);
        }
        Trace.trace(TRACE_MASKT, "<- DefaultFru.systemLevelDeactivate");
    }

    public void setServiceLock(Map userData) throws AlreadyLockedException, LockingException {
        Trace.trace(TRACE_MASKT, "-> DefaultFru.setServiceLock");
        try {
            this.getHardwareInterface(userData).setServiceLock(this.getPowerDomain(userData));
        }
        catch (Exception e) {
            Trace.trace(TRACE_MASKT, "<-! DefaultFru.setServiceLock exception caught: " + e);
            Trace.trace(TRACE_MASKT, e);
            throw new LockingException(e);
        }
        Trace.trace(TRACE_MASKT, "<- DefaultFru.setServiceLock");
    }

    public void elementLevelDeactivate(Map userData) throws DeactivateException {
        Trace.trace(TRACE_MASKT, "-> DefaultFru.elementLevelDeactivate");
        try {
            this.getHardwareInterface(userData).elementLevelDeactivate(this.getPowerDomain(userData));
        }
        catch (Exception e) {
            Trace.trace(TRACE_MASKT, "<-! DefaultFru.elementLevelDeactivate exception caught: " + e);
            Trace.trace(TRACE_MASKT, e);
            throw new DeactivateException(e);
        }
        Trace.trace(TRACE_MASKT, "<- DefaultFru.elementLevelDeactivate");
    }

    public void identify(Map userData) throws IdentifyException {
        Trace.trace(TRACE_MASKT, "-> DefaultFru.identify");
        try {
            if (this.fruLocationCode == null || this.fruLocationCode.equals("")) {
                this.fruLocationCode = (String)this.getProperties().get("LOCATION");
            }
            this.getHardwareInterface(userData).identify(this.fruLocationCode, 1);
        }
        catch (Exception e) {
            Trace.trace(TRACE_MASKT, "<-! DefaultFru.identify exception caught: " + e);
            Trace.trace(TRACE_MASKT, e);
        }
        Trace.trace(TRACE_MASKT, "<- DefaultFru.identify");
    }

    public void resetIdentify(Map userData) throws IdentifyException {
        Trace.trace(TRACE_MASKT, "-> DefaultFru.resetIdentify");
        try {
            if (this.fruLocationCode == null || this.fruLocationCode.equals("")) {
                this.fruLocationCode = (String)this.getProperties().get("LOCATION");
            }
            this.getHardwareInterface(userData).identify(this.fruLocationCode, 0);
        }
        catch (Exception e) {
            Trace.trace(TRACE_MASKT, "<-! DefaultFru.resetIdentify exception caught: " + e);
            Trace.trace(TRACE_MASKT, e);
        }
        Trace.trace(TRACE_MASKT, "<- DefaultFru.resetIdentify");
    }

    public void elementLevelActivate(Map userData) throws ActivateException {
        Trace.trace(TRACE_MASKT, "-> DefaultFru.elementLevelActivate");
        try {
            this.getHardwareInterface(userData).elementLevelActivate(this.getPowerDomain(userData));
        }
        catch (Exception e) {
            Trace.trace(TRACE_MASKT, "<-! DefaultFru.elementLevelActivate exception caught: " + e);
            Trace.trace(TRACE_MASKT, e);
            throw new ActivateException(e);
        }
        Trace.trace(TRACE_MASKT, "<- DefaultFru.elementLevelActivate");
    }

    public void resetServiceLock(Map userData) throws LockingException {
        Trace.trace(TRACE_MASKT, "-> DefaultFru.resetServiceLock");
        try {
            this.getHardwareInterface(userData).resetServiceLock(this.getPowerDomain(userData));
        }
        catch (Exception e) {
            Trace.trace(TRACE_MASKT, "<-! DefaultFru.resetServiceLock exception caught: " + e);
            Trace.trace(TRACE_MASKT, e);
            throw new LockingException(e);
        }
        Trace.trace(TRACE_MASKT, "<- DefaultFru.resetServiceLock");
    }

    public void systemLevelActivate(Map userData) throws ActivateException {
        Trace.trace(TRACE_MASKT, "-> DefaultFru.systemLevelActivate");
        try {
            this.getHardwareInterface(userData).systemLevelActivate(this.getPowerDomain(userData));
        }
        catch (Exception e) {
            Trace.trace(TRACE_MASKT, "<-! DefaultFru.systemLevelActivate exception caught: " + e);
            Trace.trace(TRACE_MASKT, e);
            throw new ActivateException(e);
        }
        Trace.trace(TRACE_MASKT, "<- DefaultFru.systemLevelActivate");
    }

    public List getInstallPanelSequence(Map userData) {
        Trace.trace(TRACE_MASKT, "-> DefaultFru.getInstallPanelSequence");
        LinkedList<CommonDataBean> returnList = new LinkedList<CommonDataBean>();
        CommonDataBean bean = null;
        while ((bean = this.getNextInstallBean(bean)) != null) {
            if (returnList.size() > this.panelStackLimit) {
                Trace.trace(TRACE_MASKT, "<-! DefaultFru.getInstallPanelSequence " + bean.getClass().getName() + " has a loop in its getNextInstallBean method");
                throw new RuntimeException(bean.getClass().getName() + " has a loop in its getNextInstallBean method");
            }
            returnList.add(this.setCommonSubs(bean));
        }
        Trace.trace(TRACE_MASKT, "<- DefaultFru.getInstallPanelSequence, number of panels in sequence: " + returnList.size());
        return returnList;
    }

    public List getRemovePanelSequence(Map userData) {
        Trace.trace(TRACE_MASKT, "-> DefaultFru.getRemovePanelSequence");
        LinkedList<CommonDataBean> returnList = new LinkedList<CommonDataBean>();
        CommonDataBean bean = null;
        while ((bean = this.getNextRemoveBean(bean)) != null) {
            if (returnList.size() > this.panelStackLimit) {
                Trace.trace(TRACE_MASKT, "<-! DefaultFru.getRemovePanelSequence " + bean.getClass().getName() + " has a loop in its getNextRemoveBean method");
                throw new RuntimeException(bean.getClass().getName() + " has a loop in its getNextRemoveBean method");
            }
            returnList.add(this.setCommonSubs(bean));
        }
        Trace.trace(TRACE_MASKT, "<- DefaultFru.getRemovePanelSequence, number of panels in sequence: " + returnList.size());
        return returnList;
    }

    public List getSetServicePositionPanelSequence(Map userData) {
        Trace.trace(TRACE_MASKT, "-> DefaultFru.getSetServicePositionPanelSequence");
        LinkedList<CommonDataBean> returnList = new LinkedList<CommonDataBean>();
        CommonDataBean bean = null;
        while ((bean = this.getNextSetServicePositionBean(bean)) != null) {
            if (returnList.size() > this.panelStackLimit) {
                Trace.trace(TRACE_MASKT, "<-! DefaultFru.getSetServicePositionPanelSequence " + bean.getClass().getName() + " has a loop in its getNextSetServicePositionBean method");
                throw new RuntimeException(bean.getClass().getName() + " has a loop in its getNextSetServicePositionBean method");
            }
            returnList.add(this.setCommonSubs(bean));
        }
        Trace.trace(TRACE_MASKT, "<- DefaultFru.getSetServicePositionPanelSequence, number of panels in sequence: " + returnList.size());
        return returnList;
    }

    public List getResetServicePositionPanelSequence(Map userData) {
        Trace.trace(TRACE_MASKT, "-> DefaultFru.getResetServicePositionPanelSequence");
        LinkedList<CommonDataBean> returnList = new LinkedList<CommonDataBean>();
        CommonDataBean bean = null;
        while ((bean = this.getNextResetServicePositionBean(bean)) != null) {
            if (returnList.size() > this.panelStackLimit) {
                Trace.trace(TRACE_MASKT, "<-! DefaultFru.getResetServicePositionPanelSequence " + bean.getClass().getName() + " has a loop in its getNextResetServicePositionBean method");
                throw new RuntimeException(bean.getClass().getName() + " has a loop in its getNextResetServicePositionBean method");
            }
            returnList.add(this.setCommonSubs(bean));
        }
        Trace.trace(TRACE_MASKT, "<- DefaultFru.getResetServicePositionPanelSequence, number of panels in sequence: " + returnList.size());
        return returnList;
    }

    public ServiceableElementMaintenance getHardwareInterface(Map userData) throws ServiceableElementException {
        boolean useDummy = false;
        try {
            if (new File("/tmp/usedummy").exists()) {
                useDummy = true;
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        if (this.hardwareInterface == null) {
            if (useDummy) {
                Trace.trace(TRACE_MASKF, "DefaultFru.getHardwareInterface **** USING DUMMY HARDWARE INTERFACE ***");
                this.hardwareInterface = new DummyServiceableElementMaintenance();
            } else {
                ManagedSystem ms = (ManagedSystem)userData.get("MANAGED_SYSTEM");
                try {
                    ServiceableElementMaintenanceFactory sef = (ServiceableElementMaintenanceFactory)ms.getFactory("ServiceableElementMaintenanceFactory");
                    this.hardwareInterface = sef.create(this, userData);
                }
                catch (Exception e) {
                    Trace.trace(TRACE_MASKT, "<-! DefaultFru.getHardwareInterface exception caught: " + e);
                    Trace.trace(TRACE_MASKT, e);
                    throw new ServiceableElementException(e);
                }
            }
        }
        return this.hardwareInterface;
    }

    public static void displayCommonPanelSequence(List panelSequence, Map userData) throws HException {
        if (panelSequence != null) {
            GenericGui guiHandle = (GenericGui)userData.get("DISPLAY_HANDLE");
            CommonDataBean bean = null;
            int index = 0;
            int sequenceSize = panelSequence.size();
            boolean refreshOnly = false;
            while (index < sequenceSize) {
                bean = (CommonDataBean)panelSequence.get(index);
                if (index == 0) {
                    bean.disablePreviousButton();
                }
                bean = !refreshOnly ? (CommonDataBean)guiHandle.replace("com.ibm.hwmca.fw.service.panel.res.CommonPanels", bean.getTemplateName(), bean, userData) : (CommonDataBean)guiHandle.update(bean, userData);
                panelSequence.set(index, bean);
                refreshOnly = false;
                String strButtonPressed = bean.getElementName();
                if (strButtonPressed.equalsIgnoreCase("ButtonNext")) {
                    ++index;
                    continue;
                }
                if (strButtonPressed.equalsIgnoreCase("ButtonPrevious")) {
                    index = index == 0 ? 0 : index - 1;
                    continue;
                }
                if (!(bean instanceof TextAndSwappableGraphicDataBean)) continue;
                if (strButtonPressed.equalsIgnoreCase("ButtonVideo")) {
                    ((TextAndSwappableGraphicDataBean)bean).setViewStaticPicture(false);
                    refreshOnly = true;
                    continue;
                }
                if (!strButtonPressed.equalsIgnoreCase("ButtonPicture")) continue;
                ((TextAndSwappableGraphicDataBean)bean).setViewStaticPicture(true);
                refreshOnly = true;
            }
        }
    }

    public static void buildAndDisplayCommonPanelSequence(ServiceableElement se, int[] sequenceSteps, Map userData) throws HException {
        if (sequenceSteps != null && se instanceof DefaultFru) {
            DefaultFru df = (DefaultFru)se;
            LinkedList<PanelSeqContainer> panelSequence = new LinkedList<PanelSeqContainer>();
            int sequenceStepsIndex = 0;
            int listIndex = 0;
            boolean prevSelected = false;
            CommonDataBean currentPanelBean = null;
            CommonDataBean firstPanelBeanInSequence = null;
            boolean done = false;
            while (!done) {
                PanelSeqContainer psc;
                if (prevSelected) {
                    currentPanelBean = DefaultFru.displayPanel(df.setCommonSubs(currentPanelBean), userData);
                } else {
                    boolean found = false;
                    while (!found && sequenceStepsIndex < sequenceSteps.length) {
                        if (sequenceSteps[sequenceStepsIndex] == 0) {
                            if ((currentPanelBean = df.getNextSetServicePositionBean(currentPanelBean)) == null) {
                                ++sequenceStepsIndex;
                                continue;
                            }
                            found = true;
                            continue;
                        }
                        if (sequenceSteps[sequenceStepsIndex] == 3) {
                            if ((currentPanelBean = df.getNextResetServicePositionBean(currentPanelBean)) == null) {
                                ++sequenceStepsIndex;
                                continue;
                            }
                            found = true;
                            continue;
                        }
                        if (sequenceSteps[sequenceStepsIndex] == 2) {
                            if ((currentPanelBean = df.getNextInstallBean(currentPanelBean)) == null) {
                                ++sequenceStepsIndex;
                                continue;
                            }
                            found = true;
                            continue;
                        }
                        if (sequenceSteps[sequenceStepsIndex] == 1) {
                            if ((currentPanelBean = df.getNextRemoveBean(currentPanelBean)) == null) {
                                ++sequenceStepsIndex;
                                continue;
                            }
                            found = true;
                            continue;
                        }
                        ++sequenceStepsIndex;
                    }
                    if (found) {
                        if (firstPanelBeanInSequence == null) {
                            firstPanelBeanInSequence = currentPanelBean;
                            firstPanelBeanInSequence.disablePreviousButton();
                        }
                        currentPanelBean = DefaultFru.displayPanel(df.setCommonSubs(currentPanelBean), userData);
                    } else {
                        done = true;
                    }
                }
                if (done) continue;
                String strButtonPressed = currentPanelBean.getElementName();
                if (strButtonPressed.equalsIgnoreCase("ButtonNext")) {
                    prevSelected = false;
                    psc = new PanelSeqContainer();
                    psc.listIndex = listIndex;
                    psc.sequenceStepsIndex = sequenceStepsIndex;
                    psc.panelBean = currentPanelBean;
                    panelSequence.add(listIndex, psc);
                    ++listIndex;
                    continue;
                }
                prevSelected = true;
                if (listIndex <= 0) continue;
                psc = (PanelSeqContainer)panelSequence.remove(listIndex - 1);
                listIndex = psc.listIndex;
                sequenceStepsIndex = psc.sequenceStepsIndex;
                currentPanelBean = psc.panelBean;
            }
        }
    }

    private static CommonDataBean displayPanel(CommonDataBean bean, Map userData) throws HException {
        boolean done = false;
        boolean refreshOnly = false;
        GenericGui guiHandle = (GenericGui)userData.get("DISPLAY_HANDLE");
        while (!done) {
            bean = !refreshOnly ? (CommonDataBean)guiHandle.replace("com.ibm.hwmca.fw.service.panel.res.CommonPanels", bean.getTemplateName(), bean, userData) : (CommonDataBean)guiHandle.update(bean, userData);
            refreshOnly = false;
            String strButtonPressed = bean.getElementName();
            if (bean instanceof TextAndSwappableGraphicDataBean) {
                if (strButtonPressed.equalsIgnoreCase("ButtonVideo")) {
                    ((TextAndSwappableGraphicDataBean)bean).setViewStaticPicture(false);
                    refreshOnly = true;
                    continue;
                }
                if (strButtonPressed.equalsIgnoreCase("ButtonPicture")) {
                    ((TextAndSwappableGraphicDataBean)bean).setViewStaticPicture(true);
                    refreshOnly = true;
                    continue;
                }
                done = true;
                continue;
            }
            done = true;
        }
        return bean;
    }

    public CommonDataBean setCommonSubs(CommonDataBean bean) {
        HashMap commonPanelSubstitutions = bean.getDataMap();
        if (commonPanelSubstitutions == null) {
            commonPanelSubstitutions = new HashMap();
            bean.setDataMap(commonPanelSubstitutions);
        }
        commonPanelSubstitutions.put("machinetype", this.getProperties().get("ENCLOSURE_TYPE"));
        commonPanelSubstitutions.put("model", this.getProperties().get("ENCLOSURE_MODEL"));
        commonPanelSubstitutions.put("serialnumber", this.getProperties().get("ENCLOSURE_SERIAL"));
        commonPanelSubstitutions.put("location", this.getProperties().get("LOCATION"));
        commonPanelSubstitutions.put("description", this.getProperties().get("DESC"));
        commonPanelSubstitutions.put("partnum", this.getProperties().get("PART_NUM"));
        return bean;
    }

    public boolean removalRequiresEnclosurePowerDown() {
        if (this.powerDomainLocationCode == null) {
            this.powerDomainLocationCode = this.getPowerDomainFromLocationCode();
        }
        return (Boolean)this.getProperty("POWER_BOUNDARY_IS_UNIT") != false;
    }

    public String getLocationSuffix() {
        Trace.trace(TRACE_MASKT, "-> DefaultFru.getLocationSuffix");
        String sFruLoc = (String)this.getProperty("LOCATION");
        try {
            int locStartIndex = sFruLoc.indexOf(45) + 1;
            int locEndIndex = sFruLoc.length();
            sFruLoc = sFruLoc.substring(locStartIndex, locEndIndex);
        }
        catch (StringIndexOutOfBoundsException e) {
            Trace.trace(TRACE_MASKF, "Bad FRU property: LOCATION = " + (String)this.getProperty("LOCATION"));
            Trace.trace(TRACE_MASKF, e.getMessage());
            sFruLoc = "";
        }
        Trace.trace(TRACE_MASKT, "<- DefaultFru.getLocationSuffix");
        return sFruLoc;
    }

    protected String[] findOtherCecFruLocations(int numLocs) {
        int i;
        Trace.trace(TRACE_MASKT, "-> DefaultFru.findOtherCecFruLocations");
        String sCecType = (String)this.getProperty("MANAGED_SYSTEM_TYPE");
        String sCecModel = (String)this.getProperty("MANAGED_SYSTEM_MODEL");
        if (sCecType == null) {
            Trace.trace(TRACE_MASKD, "getProperty(FConstants.MANAGED_SYSTEM_TYPE) returned null.");
        }
        if (sCecModel == null) {
            Trace.trace(TRACE_MASKD, "getProperty(FConstants.MANAGED_SYSTEM_MODEL) returned null.");
        }
        String sBadFruLocation = this.getLocationSuffix();
        FruConfig cecFruInfo = new FruConfig(sCecType, sCecModel);
        String[] asAllLocations = null;
        String sCecMtms = "U" + sCecType + "." + sCecModel + ".1234567";
        try {
            String sDesc = (String)this.getProperty("DESC");
            asAllLocations = cecFruInfo.queryAllowableLocations(sCecMtms, sDesc);
        }
        catch (Exception e) {
            Trace.trace(TRACE_MASKF, "Exception occurred in FruConfig.queryAllowableLocations(): " + e.getMessage());
        }
        if (asAllLocations.length != numLocs + 1) {
            Trace.trace(TRACE_MASKF, "Number of possible locations not as expected.  Possible = " + asAllLocations.length + ",  Expected = " + (numLocs + 1));
        }
        String[] asGoodLocs = new String[numLocs];
        int j = 0;
        for (i = 0; i < asAllLocations.length; ++i) {
            if (asAllLocations[i].equalsIgnoreCase(sBadFruLocation)) continue;
            asGoodLocs[j] = asAllLocations[i];
            ++j;
        }
        for (i = 0; i < numLocs; ++i) {
            if (asGoodLocs[i] != null) continue;
            asGoodLocs[i] = "";
        }
        Trace.trace(TRACE_MASKT, "<- DefaultFru.findOtherCecFruLocations");
        return asGoodLocs;
    }

    private static class PanelSeqContainer {
        public CommonDataBean panelBean;
        public int sequenceStepsIndex;
        public int listIndex;

        private PanelSeqContainer() {
        }
    }

    public static class DummyServiceableElementMaintenance
    implements ServiceableElementMaintenance {
        public void elementLevelDeactivate(String powerDomainLocation) throws ServiceableElementMaintenanceException {
        }

        public void identify(String fruLocation, int indicatorState) throws ServiceableElementMaintenanceException {
        }

        public void setUserData(Map userData) {
        }

        public void setServiceableElement(ServiceableElement se) {
        }

        public String getServiceEffect(String powerDomainLocation) throws ServiceableElementMaintenanceException {
            return "REDUNDANT";
        }

        public void systemLevelDeactivate(String powerDomainLocation) throws ServiceableElementMaintenanceException {
        }

        public void setServiceLock(String powerDomainLocation) throws ServiceableElementMaintenanceException {
        }

        public void elementLevelActivate(String powerDomainLocation) throws ServiceableElementMaintenanceException {
        }

        public void resetServiceLock(String powerDomainLocation) throws ServiceableElementMaintenanceException {
        }

        public void systemLevelActivate(String powerDomainLocation) throws ServiceableElementMaintenanceException {
        }
    }
}

